/******************************************************************************
 * Filename:       Digital_Input_Service.h
 *
 * Description:    This file contains the Digital_Input_Service service definitions and
 *                 prototypes.
 *
 *                 Generated by:
 *                 BDS version: 1.1.3135.0
 *                 Plugin:      Texas Instruments BLE SDK GATT Server plugin 1.0.8
 *                 Time:        Sat Jun 24 2017 16:55:14 GMT+01:00
 *

 * Copyright (c) 2015, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef _DIGITAL_INPUT_SERVICE_H_
#define _DIGITAL_INPUT_SERVICE_H_

#ifdef __cplusplus
extern "C"
{
#endif

/*********************************************************************
 * INCLUDES
 */
#include <bcomdef.h>

/*********************************************************************
 * CONSTANTS
 */
// Service UUID
#define DIGITAL_INPUT_SERVICE_SERV_UUID 0x1220
#define DIGITAL_INPUT_SERVICE_SERV_UUID_BASE128(uuid) 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x00, 0x40, 0x51, 0x04, LO_UINT16(uuid), HI_UINT16(uuid), 0x00, 0xF0

// IN1 Characteristic defines
#define DIS_IN1_ID                 0
#define DIS_IN1_UUID               0x1221
#define DIS_IN1_UUID_BASE128(uuid) 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x00, 0x40, 0x51, 0x04, LO_UINT16(uuid), HI_UINT16(uuid), 0x00, 0xF0
#define DIS_IN1_LEN                1
#define DIS_IN1_LEN_MIN            1

// IN2 Characteristic defines
#define DIS_IN2_ID                 1
#define DIS_IN2_UUID               0x1222
#define DIS_IN2_UUID_BASE128(uuid) 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x00, 0x40, 0x51, 0x04, LO_UINT16(uuid), HI_UINT16(uuid), 0x00, 0xF0
#define DIS_IN2_LEN                1
#define DIS_IN2_LEN_MIN            1

// IN3 Characteristic defines
#define DIS_IN3_ID                 2
#define DIS_IN3_UUID               0x1223
#define DIS_IN3_UUID_BASE128(uuid) 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB0, 0x00, 0x40, 0x51, 0x04, LO_UINT16(uuid), HI_UINT16(uuid), 0x00, 0xF0
#define DIS_IN3_LEN                1
#define DIS_IN3_LEN_MIN            1

/*********************************************************************
 * TYPEDEFS
 */

// Fields in characteristic "IN1"
//   Field "Value" format: uint8, bits: 8

// Fields in characteristic "IN2"
//   Field "Value" format: uint8, bits: 8

// Fields in characteristic "IN3"
//   Field "Value" format: uint8, bits: 8

/*********************************************************************
 * MACROS
 */

/*********************************************************************
 * Profile Callbacks
 */

// Callback when a characteristic value has changed
typedef void (*DigitalInputServiceChange_t)( uint16_t connHandle, uint16_t svcUuid, uint8_t paramID, uint8_t *pValue, uint16_t len );

typedef struct
{
  DigitalInputServiceChange_t        pfnChangeCb;     // Called when characteristic value changes
  DigitalInputServiceChange_t        pfnCfgChangeCb;  // Called when characteristic CCCD changes
} DigitalInputServiceCBs_t;



/*********************************************************************
 * API FUNCTIONS
 */


/*
 * DigitalInputService_AddService- Initializes the DigitalInputService service by registering
 *          GATT attributes with the GATT server.
 *
 *    rspTaskId - The ICall Task Id that should receive responses for Indications.
 */
extern bStatus_t DigitalInputService_AddService( uint8_t rspTaskId );

/*
 * DigitalInputService_RegisterAppCBs - Registers the application callback function.
 *                    Only call this function once.
 *
 *    appCallbacks - pointer to application callbacks.
 */
extern bStatus_t DigitalInputService_RegisterAppCBs( DigitalInputServiceCBs_t *appCallbacks );

/*
 * DigitalInputService_SetParameter - Set a DigitalInputService parameter.
 *
 *    param - Profile parameter ID
 *    len   - length of data to write
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t DigitalInputService_SetParameter( uint8_t param, uint16_t len, void *value );

/*
 * DigitalInputService_GetParameter - Get a DigitalInputService parameter.
 *
 *    param - Profile parameter ID
 *    len   - pointer to a variable that contains the maximum length that can be written to *value.
              After the call, this value will contain the actual returned length.
 *    value - pointer to data to write.  This is dependent on
 *            the parameter ID and may be cast to the appropriate
 *            data type (example: data type of uint16_t will be cast to
 *            uint16_t pointer).
 */
extern bStatus_t DigitalInputService_GetParameter( uint8_t param, uint16_t *len, void *value );

/*********************************************************************
*********************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* _DIGITAL_INPUT_SERVICE_H_ */

